quietly log using example_md, name(example_md) replace
/***
Example of a MarkDoc document
=============================

Standard Features
-----------------

### Some simple Stata input and output

Here is a regression example using the obligatory `auto` dataset,
using good physics
***/

clear
sysuse auto
// making the physics right
gen gp100m = 100/mpg
regress gp100m weight displacement gear_ratio foreign

/***
### Including a result in the body of a sentence.

This is useful for including results in sentences in a paper.
***/

txt "Markdoc can use inline expansion. As an example, we can see that the coefficient for the foreign variable is " %5.3f _b[foreign] ". It is, however, a shortcoming that any paragraph including an inline result must all be in a `txt` command in the Stata portion of the file."

/***

Note that the next paragraph can be written as a standard paragraph.

### Including a graph

Here is an example scatterplot command:
***/
twoway (scatter gp100m weight if !foreign) ///
  (scatter gp100m weight if foreign), ///
  legend(order(1 "US" 2 "Non-US"))
/**/quietly graph export scatter.png, replace
/***
Here is the graph.

![An example scatterplot](./scatter.png)


### Hiding commands and showing only results

It can be useful to hide commands and show just their output. Here, for example, is the output from a summarize command:
***/
/**/summarize gp100m weight displacement gear_ratio

/***
Showing just commands works similarly.

Showing just commands or output is done line by line.

### Splitting input and output.

Markdoc cannot directly split input and output from Stata commands.
This is typical for programs producing documents directly from Stata log files, because Stata itself mixes input and output in its log files. It is possible to split output by running commands multiple time and sometimes showing the command, sometimes showing the output.

Some other features to check
----------------------------

### Showing Mata code and output

Here is some Mata code. We don't want to see the output from the initial mata command, so we can hide it.
***/
mata
X = (76, 53, 48 \ 53, 88, 46 \ 48, 46, 63)
Xi = invsym(X)
/***
It is useful to see the output from checking that Xi is really the inverse of X.
***/
Xi*X
end
quietly log close example_md
