/*  File generated by StatWeave  */
/* --- Output file from StatWeave, engine = StataEngineSL ---
*/
cd "/Volumes/Shuttle/Training/OtherTalks/repdoc/data/lesson01"

/* ---- Chunk 1: "lesson01-outline-1-Stata" ----- */
/* !-StatWeave-!/swv~line 30~JOLRM1/code/out/
*/
sysuse auto
/* @-StatWeave-!/swv~line 30~JOLRM1/code/out/
*/
/* ---- Chunk 2: "lesson01-outline-2-Stata" ----- */
/* !-StatWeave-!/swv~line 62~JOLRM4/code/out/
*/
// Changing mpg to liter/100km
** 1 mile = 1.609 km; 1 gallon = 3.7854 liters
gen lp100km = 100/(mpg*(1.609 / 3.7854))
label var lp100km "Liters per 100km"

// Trunk size in liters
rename trunk trunk_cuft
** 1 inch = 2.54 cm, 1 foot = 12 inches, 1000 cc = 1 liter
gen trunk = (trunk_cuft*(12*2.54)^3)/1000
label var trunk "Trunk capacity (liters)"

// Weight in Kilos
** 1kg = 2.205 lb
rename weight weight_lb
gen weight = weight_lb / 2.205
label var weight "Weight in kg"

// Length in cm
rename length length_in
gen length_cm = length_in * 2.54
label var length_cm "Length in cm"

// Turning radius in cm
rename turn turn_circ_ft
gen turn_rad = round((turn_circ_ft * 12 * 2.54)/(2*c(pi)))
label var turn_rad "Turning radius in cm"

// Displacement in cc
rename displacement displacement_cuin
gen displacement = displacement_cuin * 2.54^3
label var displacement "Displacement in cc"
/* @-StatWeave-!/swv~line 62~JOLRM4/code/out/
*/
/* ---- Chunk 3: "lesson01-outline-3-Stata" ----- */
/* !-StatWeave-!/swv~line 111~JOLRM7/code/out/
*/
describe
/* @-StatWeave-!/swv~line 111~JOLRM7/code/out/
*/
/* ---- Chunk 4: "lesson01-outline-4-Stata" ----- */
/* !-StatWeave-!/swv~line 123~JOLRM10/code/out/
*/
summarize
/* @-StatWeave-!/swv~line 123~JOLRM10/code/out/
*/
/* ---- Chunk 5: "lesson01-outline-grmat" ----- */
/* !-StatWeave-!/swv~line 144~JOLRM13/code/
*/
graph matrix lp100km weight displacement foreign
/* @-StatWeave-!/swv~line 144~JOLRM13/code/
*/
/* ---- Chunk 6: "lesson01-outline-6-Stata" ----- */
graph export Graphics/grmat.eps, replace
/* @-StatWeave-!/swv~line 151~JOLRM15/
*/
/* ---- Chunk 7: "lesson01-outline-7-Stata" ----- */
/* !-StatWeave-!/swv~line 184~JOLRM16/code/out/
*/
regress lp100km weight displacement foreign
/* @-StatWeave-!/swv~line 184~JOLRM16/code/out/
*/
/* !-StatWeave-!/swv~line 195~JOLRM19/1expr
*/
display %6.5f _b[weight]
/* @-StatWeave-!/swv~line 195~JOLRM19/1expr
*/
/* !-StatWeave-!/swv~line 195~JOLRM20/2expr
*/
display %9.8f 2*ttail(e(df_r),abs(_b[weight])/_se[weight])
/* @-StatWeave-!/swv~line 195~JOLRM20/2expr
*/
smcl2swv using /Volumes/Shuttle/Training/OtherTalks/repdoc/data/lesson01/lesson01-outline-StataEngineSL.smcl, saving(/Volumes/Shuttle/Training/OtherTalks/repdoc/data/lesson01/lesson01-outline-StataEngineSL.out) replace
log using stata_check.smcl, name(swv_stata_check)

