
** We'll use the \stliteral{auto} dataset
sysuse auto

** We'll run the conversion code in the lesson, but show it only in the handouts
// Changing mpg to liter/100km
** 1 mile = 1.609 km; 1 gallon = 3.7854 liters
gen lp100km = 100/(mpg*(1.609 / 3.7854))
label var lp100km "Liters per 100km"

// Trunk size in liters
rename trunk trunk_cuft
** 1 inch = 2.54 cm, 1 foot = 12 inches, 1000 cc = 1 liter
gen trunk = (trunk_cuft*(12*2.54)^3)/1000
label var trunk "Trunk capacity (liters)"

// Weight in Kilos
** 1kg = 2.205 lb
rename weight weight_lb
gen weight = weight_lb / 2.205
label var weight "Weight in kg"

// Length in cm
rename length length_in
gen length_cm = length_in * 2.54
label var length_cm "Length in cm"

// Turning radius in cm
rename turn turn_circ_ft
gen turn_rad = round((turn_circ_ft * 12 * 2.54)/(2*c(pi)))
label var turn_rad "Turning radius in cm"

// Displacement in cc
rename displacement displacement_cuin
gen displacement = displacement_cuin * 2.54^3
label var displacement "Displacement in cc"

** Here is the structure of our new dataset
describe

** Here are the summary statistics
summarize

** We can look at dependencies
graph matrix lp100km weight displacement foreign

** From our graph, it appears we should try
regress lp100km weight displacement foreign
